#
# Makefile for FPSE/Linux i386
#

# Configure this:

CC = gcc
LD = gcc
RM = rm -f

# Select one of this (uncomment your preferred plugin):

#	cd		Linux Cdrom (normal cdrom)
#	cdiso		Iso Cdrom extension (load .iso files)
#	cdnull		Null Cdrom
#CD = cd
#CD = cdiso
CD = cdnull

# Select one for GPU and one for JOY

#	gpu		Software renderer plugin
#	joy		Keyboard joypad (read joy.c)
#	joynull		Null joypad
GPU = gpu 
JOY = joy
#JOY = joynull

# As before select only one

#	spunull		No sound
SPU = spunull

# End of Configure

DIR_INCLUDE = include
DIR_MICROPR = cpu/ix86
DIR_OSYSTEM = system/linux
DIR_LIBRARY = system/linux/plugin
DIR_OBJECTS = obj

DEFS     = -DLSB_FIRST -DLINUX
INCLUDE  = -I$(DIR_INCLUDE) -I$(DIR_OSYSTEM)
DEBUG    = -Wall
OPTIMIZE = -O3 -fomit-frame-pointer

CFLAGS   = $(DEFS) $(INCLUDE) $(DEBUG) $(OPTIMIZE)

OBJNAMES = cpu2.o mem.o emu.o hw.o bios.o win.o \
compile.o runtime.o gte.o malloc.o cdrom.o dis.o \
sio.o mdec.o idctfst.o debug.o rs232.o joypad.o \
setup.o init.o \

LIBNAMES = -l${CD} -l${JOY} -l${GPU} -l${SPU}

OBJS = $(addprefix $(DIR_OBJECTS)/, $(OBJNAMES)) 
LIBS = -L$(DIR_LIBRARY) ${LIBNAMES}

all: libs fpse

libs:
	@cd $(DIR_LIBRARY) && make -f makefile ${CD} ${JOY} ${GPU} ${SPU}

$(DIR_OBJECTS)/compile.o: $(DIR_MICROPR)/compile.c
	$(CC) $(CFLAGS) -c -o $@ $<

$(DIR_OBJECTS)/rs232.o:   $(DIR_OSYSTEM)/rs232.c
	$(CC) $(CFLAGS) -c -o $@ $<

$(DIR_OBJECTS)/init.o:    $(DIR_OSYSTEM)/init.c
	$(CC) $(CFLAGS) -c -o $@ $<

$(DIR_OBJECTS)/setup.o:   $(DIR_OSYSTEM)/setup.c
	$(CC) $(CFLAGS) -c -o $@ $<

$(DIR_OBJECTS)/win.o:     $(DIR_OSYSTEM)/win.c
	$(CC) $(CFLAGS) -c -o $@ $<

$(DIR_OBJECTS)/%.o: %.c
	$(CC) $(CFLAGS) -c -o $@ $<

fpse: $(OBJS) libs
	$(LD) $(CFLAGS) -o fpse $(OBJS) $(LIBS)

force: libs
	$(LD) $(CFLAGS) -o fpse $(OBJS) $(LIBS)

dis.exe: dis.c
	$(CC) $(CFLAGS) dis.c -o dis.exe -DMAKEDIS

clean :
	@cd $(DIR_LIBRARY) && make -f makefile clean
	$(RM) *.exe fpse
	$(RM) $(DIR_OBJECTS)/*.o
